﻿----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------

thirdPerson = {};
thirdPerson.noBackwalk = false;
thirdPerson.linkFlashlight = false;
thirdPerson.cameraRotationLimited = true;
thirdPerson.disableCrouchHeight = false;
thirdPerson.flashlightDistance = 2.5;
thirdPerson.flashlightHeight = 1.2;
thirdPerson.defaultCrosshairColor = {1,0,0,0.3} --rgba
thirdPerson.modDir = g_currentModDirectory;
local modDescFile = loadXMLFile("modDesc", thirdPerson.modDir.."modDesc.xml");
thirdPerson.title = getXMLString(modDescFile, "modDesc.title.en");
thirdPerson.author = getXMLString(modDescFile, "modDesc.author");
thirdPerson.version = getXMLString(modDescFile, "modDesc.version");
delete(modDescFile);

function thirdPerson:loadMap(savegame)
	if g_currentMission:getIsClient() then
		thirdPerson.events = {};
		thirdPerson:loadSettings();
		thirdPerson:updateGameFunctions();
		print(thirdPerson.title.." : v"..thirdPerson.version.." by "..thirdPerson.author.." activated");
	end;
end;

function thirdPerson:update()
	if g_currentMission:getIsClient() then
		if g_currentMission.thirdPersonInitialized == nil then
			thirdPerson:initialize(g_currentMission);
		end;
		 thirdPerson:checkHands(g_currentMission.player);
		thirdPerson:updateCameraZoom(false);
		local player = g_currentMission.player;
		player.baseInformation.isCrouched = player.playerStateMachine:isActive("crouch");
	 end;
end;

function thirdPerson:updateGameFunctions()
	Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, thirdPerson.registerActionEvents);
	Player.removeActionEvents = Utils.appendedFunction(Player.removeActionEvents, thirdPerson.removeActionEvents);
	Player.update = Utils.overwrittenFunction(Player.update, thirdPerson.updatePlayer);
	Player.updateRotation = Utils.overwrittenFunction(Player.updateRotation, thirdPerson.updatePlayerRotation);
	Player.onLeaveVehicle = Utils.appendedFunction(Player.onLeaveVehicle, thirdPerson.onLeaveVehicle);
	Player.moveTo = Utils.appendedFunction(Player.moveTo, thirdPerson.onLeaveVehicle);
	ConstructionScreen.onClose = Utils.appendedFunction(ConstructionScreen.onClose, thirdPerson.onLeaveVehicle);
	Player.equipHandtool = Utils.overwrittenFunction(Player.equipHandtool, thirdPerson.equipHandtool);
	PlayerStateCrouch.deactivate = Utils.overwrittenFunction(PlayerStateCrouch.deactivate, thirdPerson.deactiveCrouch);
	PlayerStyle.loadFromXMLFile = Utils.appendedFunction(PlayerStyle.loadFromXMLFile, thirdPerson.loadFromXMLFile);
	PlayerStyle.saveToXMLFile = Utils.appendedFunction(PlayerStyle.saveToXMLFile, thirdPerson.saveToXMLFile);
	if thirdPerson.disableCrouchHeight then
		Player.updateCameraTranslation = Utils.overwrittenFunction(Player.updateCameraTranslation, thirdPerson.updateCameraTranslation);
	end;
end;

function thirdPerson:saveToXMLFile(xmlFile, key)
	if g_currentMission.player ~= nil then
		local z = Utils.getNoNil(g_currentMission.player.thirdPersonViewDistance,0);
		if z ~= 0 then
			z = z*10;
			z = math.floor(z);
			z = z/10;
		end;
		xmlFile:setFloat("players.thirdPerson#viewDistance", z);
	end;
end;

function thirdPerson:loadFromXMLFile(xmlFile, key)
	local z = Utils.getNoNil(xmlFile:getFloat("players.thirdPerson#viewDistance"),0);
	if z ~= 0 then
		z = z*10;
		z = math.floor(z);
		z = z/10;
	end;
	g_currentMission.thirdPersonViewDistance = z;
end;

function thirdPerson:loadSettings(attemptIndex)
	if attemptIndex == nil then attemptIndex = 0; end;
	local nilValues = 0;
	local overwriteFile = attemptIndex >= 1;
	local function countMissingValues(var)
		if var == nil then return 1; end;
		return 0;
	end;
	local settingsFilePath = getUserProfileAppPath().."modSettings/thirdPerson.xml";
	if not fileExists(settingsFilePath) or overwriteFile then
		copyFile(thirdPerson.modDir.."settingsTemplate.xml", settingsFilePath, overwriteFile);
	end;
	local settingsFile = loadXMLFile("thirdPerson_XML", settingsFilePath, "thirdPersonSettings");
	local noBackwalk = getXMLBool(settingsFile, "thirdPerson.noWalkingBackwards#value"); nilValues = nilValues + countMissingValues(noBackwalk);
	local linkFlashlight = getXMLBool(settingsFile, "thirdPerson.flashlight#useCharacterDirection"); nilValues = nilValues + countMissingValues(linkFlashlight);
	local cameraRotationLimited = getXMLBool(settingsFile, "thirdPerson.camera#limitRotationXaxis"); nilValues = nilValues + countMissingValues(cameraRotationLimited);
	local disableCrouchHeight = getXMLBool(settingsFile, "thirdPerson.camera#disableCrouchHeightAdjustment"); nilValues = nilValues + countMissingValues(disableCrouchHeight);
	delete(settingsFile);
	thirdPerson.noBackwalk = Utils.getNoNil(noBackwalk, thirdPerson.noBackwalk);
	thirdPerson.linkFlashlight = Utils.getNoNil(linkFlashlight, thirdPerson.linkFlashlight);
	thirdPerson.cameraRotationLimited = Utils.getNoNil(cameraRotationLimited, thirdPerson.cameraRotationLimited);
	thirdPerson.disableCrouchHeight = Utils.getNoNil(disableCrouchHeight, thirdPerson.disableCrouchHeight);
	if nilValues > 0 then
		if attemptIndex < 1 then
			print(thirdPerson.title.." : Settings file updated!");
			thirdPerson:loadSettings(attemptIndex +1);
			return;
		else
			Logging.warning(thirdPerson.title.." : Settings file update failed: missing values; using default settings..");
			return;
		end;
	end;
	 if g_currentMission.missionDynamicInfo ~= nil and g_currentMission.missionDynamicInfo.isMultiplayer then
		thirdPerson.noBackwalk = true;
	 end;
	print(thirdPerson.title.." : Loaded settings from file: "..settingsFilePath);
end;

function thirdPerson:registerActionEvents()
	if self.isClient then
		thirdPerson.events = {};
		local valid, eventId = g_inputBinding:registerActionEvent(InputAction.PLAYERCAMERA, InputBinding.NO_EVENT_TARGET, thirdPerson.changeCamera, false, true, false, true);
		if valid then
			table.insert(thirdPerson.events, eventId);
			g_inputBinding:setActionEventText(eventId, g_i18n:getText("input_CAMERA_SWITCH"));
			g_inputBinding:setActionEventTextVisibility(eventId, true);
			g_inputBinding:setActionEventTextPriority(eventId, GS_PRIO_NORMAL);
		end;
	end;
end;

function thirdPerson:removeActionEvents()
	g_inputBinding:removeActionEvent(thirdPerson.events[1]);
	thirdPerson.events = {};
end;

function thirdPerson:onLeaveVehicle()
	if g_currentMission.player.thirdPersonViewActive then
		thirdPerson:changeCamera();
		thirdPerson:changeCamera();
	end;
end;

function thirdPerson:setFlashLight(player)
	if player.model.lightNode ~= nil then
		local x,y,z = getTranslation(player.model.lightNode);
		local xR,yR,zR = getRotation(player.model.lightNode);
		if player.defaultLightPosition == nil then
			player.defaultLightPosition = {x,y,z};
			player.defaultLightRotation = {xR,yR,zR};
		end;
		if g_currentMission.player.thirdPersonViewActive then
			if thirdPerson.linkFlashlight then
				link(player.model.skeletonRootNode, player.model.lightNode);
				setRotation(player.model.lightNode, xR,yR+math.rad(180),zR);
				setTranslation(player.model.lightNode, x,y+thirdPerson.flashlightHeight,z);
			else
				setTranslation(player.model.lightNode, x,y,z-thirdPerson.flashlightDistance);
			end;
		else
			if thirdPerson.linkFlashlight then
				link(player.cameraNode, player.model.lightNode);
			end;
			x,y,z = unpack(player.defaultLightPosition);
			setTranslation(player.model.lightNode, x,y,z);
			x,y,z = unpack(player.defaultLightRotation);
			setRotation(player.model.lightNode, x,y,z);
		end;
	end;
end;

function thirdPerson:setCrosshair(player)
	if player.thirdPersonViewActive then
		player.aimOverlay:setColor(0, 0, 0, 0);
	elseif g_currentMission.customCrosshair ~= nil then
		local r,g,b,a = unpack(g_currentMission.customCrosshair);
		player.aimOverlay:setColor(r, g, b, a);
	else
		local r,g,b,a = unpack(thirdPerson.defaultCrosshairColor);
		player.aimOverlay:setColor(r, g, b, a);
	end;
	if g_currentMission.customCrosshair == nil then
		player.pickedUpObjectOverlay:setColor(0, 1, 0, 0.3);
		player.petOverlay:setColor(0, 0, 1, 0.3);
	end;
end;

function thirdPerson:changeCamera(actionName, keyStatus, arg3, arg4, arg5)
	if actionName == nil or actionName == "PLAYERCAMERA" then
		local camX = g_currentMission.player.rotX;
		local camY = g_currentMission.player.rotY;
		g_currentMission.player:setThirdPersonViewActive(not g_currentMission.player.thirdPersonViewActive);
		local x,y,z = getRotation(g_currentMission.player.graphicsRootNode);
		setRotation(g_currentMission.player.graphicsRootNode, x,y+math.rad(180),z);
		if g_currentMission.player.thirdPersonViewActive then
			g_currentMission.player:setRotation(camX,camY);
			g_currentMission.player.model:setSkeletonRotation(camY);
			thirdPerson:updateCameraZoom(true);
		end;
		thirdPerson:setFlashLight(g_currentMission.player);
		thirdPerson:setCrosshair(g_currentMission.player);
	end;
end;

function thirdPerson:updateCameraZoom(restore)
	if restore then
		local cam = getCamera();
		local x,y,z = getTranslation(cam);
		y = Utils.getNoNil(g_currentMission.player.camY,y);
		z = g_currentMission.player.thirdPersonViewDistance;
		setTranslation(cam,x,y,z);
	elseif g_currentMission.player:getIsInputAllowed() then
		if g_currentMission.player.thirdPersonViewActive then
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				local cam = getCamera();
				local x,y,z = getTranslation(cam);
				z = z+0.1; z = math.min(z,0.9);
				setTranslation(cam,x,y,z);
				g_currentMission.player.thirdPersonViewDistance = z;
			elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
				local cam = getCamera();
				local x,y,z = getTranslation(cam);
				z = z-0.1; z = math.max(z,-10);
				setTranslation(cam,x,y,z);
				g_currentMission.player.thirdPersonViewDistance = z;
			elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
				local cam = getCamera();
				local x,y,_ = getTranslation(cam);
				setTranslation(cam,x,y,0);
				g_currentMission.player.thirdPersonViewDistance = 0;
			end;
		end;
	end;
end;

function thirdPerson:initialize(mission)
	--[[if mission.thirdPersonInitializedDelay == nil then
		if not g_gui:getIsGuiVisible() then --new game starts with character select screen
			mission.thirdPersonInitializedDelay = (g_time/1000)+2.5;
		end;
	elseif g_time > mission.thirdPersonInitializedDelay then]]
		mission.player.thirdPersonViewDistance = Utils.getNoNil(mission.thirdPersonViewDistance,0);
		mission.thirdPersonViewDistance = nil;
		--thirdPerson:changeCamera();
		if g_addTestCommands then
			removeConsoleCommand("gsPlayerThirdPerson");
		end;
		mission.thirdPersonInitializedDelay = nil;
		mission.thirdPersonInitialized = true;
	--end;
end;

function thirdPerson:equipHandtool(superFunc,...)
	if not self.thirdPersonViewActive then
		superFunc(self,...);
	end;
end;

function thirdPerson:updateCameraTranslation(superFunc,...)
	if not self.thirdPersonViewActive then
		superFunc(self,...);
	end;
end;

function thirdPerson:deactiveCrouch(superFunc)
	if not self.player.thirdPersonViewActive then
		superFunc(self);
	else
		PlayerStateCrouch:superClass().deactivate(self);
	end;
end

function thirdPerson:checkHands(player)
	if player.thirdPersonViewActive then
		if player:hasHandtoolEquipped() or player.isCarryingObject then
			thirdPerson:changeCamera();
		end;
	end;
end;

function thirdPerson:checkGUI(player)
	if g_gui:getIsGuiVisible() then
		if player.thirdPersonViewActive and player.restartThirdPerson == nil then
			player.restartThirdPerson = true;
			thirdPerson:changeCamera();
		end;
	elseif player.restartThirdPerson ~= nil then
		if not player.thirdPersonViewActive then
			thirdPerson:changeCamera();
		end;
		player.restartThirdPerson = nil;
	end;
end;

function thirdPerson:updatePlayerRotation(superFunc, dt)
	if not self.isEntered and self == g_currentMission.player then
		local animDt = 60;
		self.animUpdateTime = self.animUpdateTime + dt;
		if animDt < self.animUpdateTime then
			if self.isServer then
				local x, _, z = localDirectionToLocal(self.cameraNode, getParent(self.cameraNode), 0, 0, 1);
				local alpha = math.atan2(x, z);
				self.cameraRotY = alpha;
			end;
			local x, y, z = getTranslation(self.graphicsRootNode);
			local dx = x - self.lastAnimPosX;
			local _ = y - self.lastAnimPosY;
			local dz = z - self.lastAnimPosZ;
			local dirX = -math.sin(self.cameraRotY);
			local dirZ = -math.cos(self.cameraRotY);
			local movementDist = dx * dirX + dz * dirZ;
			if dx * dx + dz * dz < 0.001 then
				self.targetGraphicsRotY = self.cameraRotY + math.rad(180);
			elseif movementDist > -0.001 then
				self.targetGraphicsRotY = math.atan2(dx, dz);
			else
				self.targetGraphicsRotY = math.atan2(-dx, -dz);
			end;
			dirZ = -math.cos(self.targetGraphicsRotY);
			dirX = -math.sin(self.targetGraphicsRotY);
			movementDist = dx * dirX + dz * dirZ;
			movementDist = self.walkDistance * 0.2 + movementDist * 0.8;
			self.walkDistance = movementDist;
			self.lastEstimatedForwardVelocity = -movementDist / (self.animUpdateTime * 0.001);
			self.lastAnimPosX = x;
			self.lastAnimPosY = y;
			self.lastAnimPosZ = z;
			self.baseInformation.animDt = self.animUpdateTime;
			self.animUpdateTime = 0;
		end;
		self.targetGraphicsRotY = MathUtil.normalizeRotationForShortestPath(self.targetGraphicsRotY, self.graphicsRotY);
		local maxDeltaRotY = math.rad(0.5) * dt;
		self.graphicsRotY = math.min(math.max(self.targetGraphicsRotY, self.graphicsRotY - maxDeltaRotY), self.graphicsRotY + maxDeltaRotY);
		self.model:setSkeletonRotation(self.graphicsRotY);
	elseif self.thirdPersonViewActive or self ~= g_currentMission.player then
		local animDt = 60;
		self.animUpdateTime = self.animUpdateTime + dt;
		if animDt < self.animUpdateTime then
			local x, y, z = getTranslation(self.graphicsRootNode);
			local dx = x - self.lastAnimPosX;
			local _ = y - self.lastAnimPosY;
			local dz = z - self.lastAnimPosZ;
			if self ~= g_currentMission.player then dx = -dx; dz = -dz; end;
			local horizontalSpeed = math.sqrt(dx * dx + dz * dz);
			self.horizontalSpeed = horizontalSpeed;
			local _,cY,_ = getRotation(self.thirdPersonLookatNode);
			if self ~= g_currentMission.player then self.cameraRotY = cY; end;
			local dirX = math.sin(cY);
			local dirZ = math.cos(cY);
			local movementDist = (dx * dirX) + (dz * dirZ);
			if dx * dx + dz * dz < 0.001 then
				--self.targetGraphicsRotY = self.cameraRotY; --Causes player to face south at stand still (MP)
			elseif movementDist > 0.001 and not thirdPerson.noBackwalk then
				self.targetGraphicsRotY = math.atan2(dx, dz);
			else
				self.targetGraphicsRotY = math.atan2(-dx, -dz);
			end;
			dirZ = math.cos(self.targetGraphicsRotY);
			dirX = math.sin(self.targetGraphicsRotY);
			movementDist = (dx * dirX) + (dz * dirZ);
			movementDist = self.walkDistance * 0.2 + movementDist * 0.8;
			self.walkDistance = movementDist;
			self.lastEstimatedForwardVelocity = -movementDist / (self.animUpdateTime * 0.001);
			if self == g_currentMission.player then
				self.oldYaw = self.newYaw;
				self.newYaw = self.cameraRotY;
				self.estimatedYawVelocity = MathUtil.getAngleDifference(self.newYaw, self.oldYaw) / dt * math.min(self.horizontalSpeed * 50, 10);
			end;
			self.lastAnimPosX = x;
			self.lastAnimPosY = y;
			self.lastAnimPosZ = z;
			self.baseInformation.animDt = self.animUpdateTime;
			self.animUpdateTime = 0;
		end;
		self.targetGraphicsRotY = MathUtil.normalizeRotationForShortestPath(self.targetGraphicsRotY, self.graphicsRotY);
		local maxDeltaRotY = math.rad(0.5) * dt;
		self.graphicsRotY = math.min(math.max(self.targetGraphicsRotY, self.graphicsRotY - maxDeltaRotY), self.graphicsRotY + maxDeltaRotY);
		if self == g_currentMission.player then
			self.cameraRotY = self.graphicsRotY;
		end;
		self.model:setSkeletonRotation(self.graphicsRotY);
	end;
end;

function thirdPerson:updatePlayer(superFunc, dt)
	self.time = self.time + dt;
	if not self.isEntered and self.isClient and self.isControlled then
		self:updateFX();
	end;
	if self.isServer or self.isEntered then
		local _, _, isOnGround = getCCTCollisionFlags(self.controllerIndex);
		self.baseInformation.isOnGroundPhysics = isOnGround;
	end;
	if self.isClient and self.isControlled then
		self:updateWaterParams();
		if Platform.hasPlayer then
			self:updateSound();
		end;
	end;
	if self.isEntered and self.isClient and not g_gui:getIsGuiVisible() and not g_currentMission.isPlayerFrozen then
		self:updatePlayerStates();
		self.playerStateMachine:update(dt);
		self:recordPositionInformation();
		local bobDelta = 0;
		if self.cameraBobbingEnabled and not self.thirdPersonViewActive then
			bobDelta = self:cameraBob(dt);
		end;
		self:updateCameraTranslation(bobDelta);
		self:debugDraw();
		self.playerStateMachine:debugDraw(dt);
		if not self.walkingIsLocked then
			self.rotX = self.rotX - self.inputInformation.pitchCamera * g_gameSettings:getValue(GameSettings.SETTING.CAMERA_SENSITIVITY);
			self.rotY = self.rotY - self.inputInformation.yawCamera * g_gameSettings:getValue(GameSettings.SETTING.CAMERA_SENSITIVITY);
			if self.thirdPersonViewActive then ---------------------------------------Start Function Mod
				--self.rotX = math.min(0, math.max(-1, self.rotX));
				if thirdPerson.cameraRotationLimited then
					self.rotX = math.min(1.2, math.max(-1.5, self.rotX));
				end; ---------------------------------------------------------------------End Function Mod
				setRotation(self.thirdPersonLookatNode, -self.rotX, self.rotY, 0);
			else
				self.rotX = math.min(1.2, math.max(-1.5, self.rotX));
				setRotation(self.cameraNode, self.rotX, self.rotY, 0);
				setRotation(self.foliageBendingNode, 0, self.rotY, 0);
			end;
		end;
		self:updateActionEvents();
		local x, y, z = getWorldTranslation(self.cameraNode);
		g_currentMission.activatableObjectsSystem:setPosition(x, y, z);
	end;
	if self:hasHandtoolEquipped() then
		self.baseInformation.currentHandtool:update(dt, self:getIsInputAllowed());
		if self.playerStateMachine:isActive("swim") then
			self:unequipHandtool();
		end;
	end;
	self:updateInterpolation();
	local isModelVisible = self.isClient and self.isControlled or self.thirdPersonViewActive;
	if isModelVisible then
		self:updateRotation(dt);
	end;
	if self.isClient and self.isControlled and (not self.isEntered or isModelVisible) then
		self:updateAnimationParameters(dt);
		self.model:updateAnimations(dt);
	end;
	if self.allowPlayerPickUp then
		self:checkObjectInRange();
	end;
	if self.isEntered or self.networkInformation.interpolationTime.isDirty then
		self:raiseActive();
	end;
	if self.isClient and self.isControlled and not self.isEntered and self.networkInformation.rotateObject then
		self:rotateObject(self.networkInformation.rotateObjectInputV, 1, 0, 0);
		self:rotateObject(self.networkInformation.rotateObjectInputH, 0, 1, 0);
	end;
	self:resetCameraInputsInformation();
	if self.isEntered then
		self.hudUpdater:update(dt, self:getPositionData());
	end;
end;

addModEventListener(thirdPerson);