TerrainLeveler = {}

function TerrainLeveler:loadMap(name)
    self.markersActive = false
    self.markers = {}
    self.shiftPressed = false
end

function TerrainLeveler:deleteMap()
    self.markersActive = false
    self.markers = {}
    self.shiftPressed = false
end

function TerrainLeveler:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_lshift then
        self.shiftPressed = true
    elseif not isDown and sym == Input.KEY_lshift then
        self.shiftPressed = false
    elseif isDown and sym == Input.KEY_m and self.shiftPressed then
        self.markersActive = not self.markersActive
        g_currentMission:addExtraPrintText(g_i18n:getText("MARKERS_TOGGLED"))
    elseif isDown and sym == Input.KEY_n and self.shiftPressed then
        local x, y, z = getWorldTranslation(getCamera())
        if g_server ~= nil then
            self:flattenTerrain(x, y, z)
        else
            g_client:getServerConnection():sendEvent(FlattenTerrainRequestEvent.new(x, y, z))
        end
    end
end

function TerrainLeveler:draw()
    -- Mostrar el mensaje "MARKERS_TOGGLED" siempre
    g_currentMission:addExtraPrintText(g_i18n:getText("MARKERS_TOGGLED"))
    g_currentMission:addExtraPrintText(g_i18n:getText("MARKERS_TOGGLED_2"))

    if self.markersActive and #self.markers > 0 then
        for _, marker in ipairs(self.markers) do
            drawDebugLine(marker.x - 1, marker.y, marker.z, 1, 0, 0, marker.x + 1, marker.y, marker.z, 1, 0, 0)
            drawDebugLine(marker.x, marker.y, marker.z - 1, 0, 1, 0, marker.x, marker.y, marker.z + 1, 0, 1, 0)
        end
    end
end

function TerrainLeveler:flattenTerrain(x, y, z)
    local radius = 5
    local totalHeight = 0
    local count = 0
    
    -- Calcula la altura promedio del área circundante
    local heights = {}
    for i = -radius, radius do
        for j = -radius, radius do
            local dist = math.sqrt(i*i + j*j)
            if dist <= radius then
                local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x + i, y, z + j)
                totalHeight = totalHeight + height
                count = count + 1
                table.insert(heights, {x = x + i, z = z + j, height = height})
            end
        end
    end
    
    local averageHeight = totalHeight / count

    -- Ajusta la altura del terreno al promedio calculado
    for _, pos in ipairs(heights) do
        setTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, pos.x, averageHeight, pos.z, averageHeight)
    end

    g_currentMission:addExtraPrintText(string.format(g_i18n:getText("TERRAIN_FLATTENED_LOG"), x, y, z))
end

function TerrainLeveler:update(dt)
    if self.shiftPressed then
        local x, y, z = getWorldTranslation(getCamera())
        local radius = 5
        self.markers = {}

        for i = -radius, radius do
            for j = -radius, radius do
                local dist = math.sqrt(i*i + j*j)
                if dist <= radius then
                    local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x + i, y, z + j)
                    table.insert(self.markers, {x = x + i, y = height, z = z + j})
                end
            end
        end
    end
end

addModEventListener(TerrainLeveler)

-- Evento para que un cliente solicite aplanar el terreno al servidor
FlattenTerrainRequestEvent = {}
FlattenTerrainRequestEvent_mt = Class(FlattenTerrainRequestEvent, Event)

function FlattenTerrainRequestEvent.emptyNew()
    local self = Event.new(FlattenTerrainRequestEvent_mt)
    return self
end

function FlattenTerrainRequestEvent.new(x, y, z)
    local self = FlattenTerrainRequestEvent.emptyNew()
    self.x = x
    self.y = y
    self.z = z
    return self
end

function FlattenTerrainRequestEvent:readStream(streamId, connection)
    self.x = streamReadFloat32(streamId)
    self.y = streamReadFloat32(streamId)
    self.z = streamReadFloat32(streamId)
    self:run(connection)
end

function FlattenTerrainRequestEvent:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.x)
    streamWriteFloat32(streamId, self.y)
    streamWriteFloat32(streamId, self.z)
end

function FlattenTerrainRequestEvent:run(connection)
    -- Solo ejecuta esta parte del código en el servidor
    if g_server ~= nil then
        TerrainLeveler:flattenTerrain(self.x, self.y, self.z)
    end
end

Event.register(FlattenTerrainRequestEvent)
