GameSaver = {};
GameSaver.render = false;
GameSaver.showSaveDialog = false;

function GameSaver:update(superfunc, dt)
	if self:getIsAutoSaveAllowed() and g_currentMission:getIsServer() and g_currentMission.gameStarted and self.time < g_time then
		self.isPending = true;
		self:runAutoSaveIfPending(true);
		self.saveNextFrame = false;
		GameSaver.render = true;
	end;
	
	GameSaver:prependSaveDisplay(self);
	GameSaver:completedSaveDisplay();
end;
AutoSaveManager.update = Utils.overwrittenFunction(AutoSaveManager.update, GameSaver.update);

function GameSaver:prependSaveDisplay(self)
	local savetimeSec = self.time/1000;
	local timeInSec = g_time/1000;
	local remainingSec = math.floor(savetimeSec - timeInSec);
	if remainingSec < 11 then
		local textString = g_i18n:getText("ui_autoSave").." in : "..remainingSec.."sec";
		local textSize = 0.02;
		textSize = textSize*g_gameSettings:getValue("uiScale");
		local oX = textSize * HUDTextDisplay.SHADOW_OFFSET_FACTOR;
		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextColor(0,0,0,1);
		renderText(0.5+oX,0.1-oX,textSize,textString);
		setTextColor(0,0.5,0,1);
		renderText(0.5,0.1,textSize,textString);
	end;

	--g_currentMission:addExtraPrintText(tostring(self.time/1000).." : "..tostring(g_time/1000));

	if g_currentMission.gameSaver_exitGame ~= nil then
		if self.gsSaveQuit == nil then
		self.gsSaveQuit = true;
		self.canceledQuitSaveTime = self.time;
		self.time = g_time+5000;
		end;
		if Utils.getNoNil(Input.isKeyPressed(Input.KEY_lctrl), false) then
			self.time = self.canceledQuitSaveTime;
			g_currentMission.gameSaver_exitGame = nil;
			self.gsSaveQuit = nil;
		end;
	end;
end;

function GameSaver:startSavingGameDisplay(superfunc)
	if g_gui:getIsGuiVisible() or GameSaver.showSaveDialog then
		g_gui:showMessageDialog({isCloseAllowed = false, visible = true, text = g_i18n:getText("ui_savingContent")}); -- self.l10n:getText(InGameMenu.L10N_SYMBOL.SAVING_CONTENT)
		self.savingMinEndTime = getTimeSec() + SavegameController.SAVING_DURATION;
		self.isSaving = true;
		self.isSavingWithGUI = true;
	end;
end;
InGameMenu.startSavingGameDisplay = Utils.overwrittenFunction(InGameMenu.update, GameSaver.startSavingGameDisplay);

function GameSaver:completedSaveDisplay()
	if GameSaver.render then
		local sec = g_time/1000;
		if GameSaver.renderTimeInt == nil then
			GameSaver.renderTimeInt = sec;
		end;
		local delayTime = (2+SavegameController.SAVING_DURATION) - (sec - GameSaver.renderTimeInt);
		if delayTime < 0 then
			GameSaver.render = false;
			GameSaver.renderTimeInt = nil;
			----
			g_currentMission.inGameMenu.doSaveGameState = InGameMenu.SAVE_STATE_NONE;
			g_currentMission.inGameMenu.savingMinEndTime = 0;
			g_currentMission.inGameMenu.isSaving = false;
			g_currentMission.inGameMenu.savingDisplayTimer = nil;
			----
			if g_currentMission.inGameMenu.isSavingWithGUI ~= nil then
				g_gui:showMessageDialog({visible = false});
				g_currentMission.inGameMenu.isSavingWithGUI = nil;
			end;
			----
			local text = g_i18n:getText("ui_autoSave").." "..string.lower(g_i18n:getText("fieldJob_finished")); -- > "Auto save completed"
			g_currentMission.hud:addSideNotification({0,1,0,1}, text, nil, GuiSoundPlayer.SOUND_SAMPLES.NOTIFICATION);
			if g_currentMission.gameSaver_exitGame ~= nil then
				requestExit();
			end;
		end;
	end;
end;