helperQuit = {};

function helperQuit.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(AIVehicle, specializations)
		and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function helperQuit.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", helperQuit);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", helperQuit);
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", helperQuit);
end;

function helperQuit:onLoad(savegame)
	self.spec_helperQuit = {};
	local spec = self.spec_helperQuit;
	spec.helperQuitEvents = {};
	spec.helperQuitEventIds = {};
	spec.renderText = false;
	spec.l10nText = g_i18n:getText("l10n_saveShutdownInfo");
	spec.gameSaver_exitGame = false;
end;

function helperQuit:onUpdate(dt)
	local spec = self.spec_helperQuit;
	if self:getRootVehicle() == g_currentMission.controlledVehicle then
		if self:getIsAIActive() and not spec.renderText then
			for _, actionEventId in pairs(spec.helperQuitEventIds) do
				g_inputBinding:setActionEventTextVisibility(actionEventId, true);
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH);
			end;
			spec.renderText = true;
		elseif not self:getIsAIActive() and spec.renderText then
			for _, actionEventId in pairs(spec.helperQuitEventIds) do
				g_inputBinding:setActionEventTextVisibility(actionEventId, false);
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH);
			end;
			spec.renderText = false;
		end;
	end;

	if spec.gameSaver_exitGame then
		local actionId1 = g_inputBinding:getActionByName("TOGGLE_AI"):getBindings();
		local actionId2 = g_inputBinding:getActionByName("helperQuit_Key"):getBindings();
		if actionId1[1].isPressed and not actionId2[1].isPressed then
			if self:getRootVehicle() == g_currentMission.controlledVehicle then
				spec.gameSaver_exitGame = false;
				spec.renderText = false;
			end;
		end;
	end;

	if spec.gameSaver_exitGame then
		if self:getRootVehicle() == g_currentMission.controlledVehicle then
			g_currentMission:addExtraPrintText(spec.l10nText);
		end;
		if not self:getIsAIActive() then
			spec.gameSaver_exitGame = false;
			local moreWorkersToFinish = false;
			for _, vehicle in pairs(g_currentMission.vehicles) do
				if vehicle ~= self and vehicle:getRootVehicle().spec_helperQuit ~= nil then
					if spec.gameSaver_exitGame then
						moreWorkersToFinish = true;
					end;
				end;
			end;
			if not moreWorkersToFinish then
				g_currentMission.gameSaver_exitGame = true;
			end;
		end;
	end;
end;

function helperQuit:toggleQuit(actionName, keyStatus, arg3, arg4, arg5)
	if actionName == "helperQuit_Key" then
		if self:getIsAIActive() then
			local spec = self.spec_helperQuit;
			if not spec.gameSaver_exitGame then
				spec.gameSaver_exitGame = true;
				for _, actionEventId in pairs(spec.helperQuitEventIds) do
					g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("input_helperQuit_Key2"));
				end;
			else
				spec.gameSaver_exitGame = false;
				for _, actionEventId in pairs(spec.helperQuitEventIds) do
					g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("input_helperQuit_Key"));
				end;
			end;
		end;
	end;
end;

function helperQuit:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		local spec = self.spec_helperQuit;
		self:clearActionEventsTable(spec.helperQuitEvents);
		spec.helperQuitEventIds = {};
        if self:getIsActiveForInput(true, true) then
			local _, actionEventId = self:addActionEvent(spec.helperQuitEvents, 'helperQuit_Key', self, helperQuit.toggleQuit, false, true, false, true, nil);
			g_inputBinding:setActionEventTextVisibility(actionEventId, false);
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH);
			table.insert(spec.helperQuitEventIds, actionEventId);
		end;
	end;
end;