﻿source(Utils.getFilename("helperQuit.lua", g_currentModDirectory));

function installSpec()
	if g_specializationManager:getSpecializationByName("helperQuit") == nil then
		if helperQuit == nil then 
			print("ERROR: unable to find source file 'helperQuit.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isHireable = false;
					local isAnimated = false;
					for name, spec in pairs(typeDef.specializationsByName) do
						if string.lower(name) == "aivehicle" then 
							isHireable = true;
						elseif string.lower(name) == "animatedvehicle" then 
							isAnimated = true;
						end;
					end;
					if isHireable and isAnimated then
						 if typeDef.specializationsByName["helperQuit"] == nil then
							table.insert(typeDef.specializations, helperQuit);
							table.insert(typeDef.specializationNames, "helperQuit");
							typeDef.specializationsByName["helperQuit"] = helperQuit;
						end;
					end;
				end;
			end;
		end;	
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);