Surprise = {}

function Surprise:loadMap(name)
    print("Surprise mod loaded.")
end

function Surprise:deleteMap()
    -- Se limpia cualquier referencia cuando se elimina el mapa
end

function Surprise:addMoney(amount)
    -- Solo ejecuta esta parte del código en el servidor
    if g_server ~= nil then
        local farmId = g_currentMission:getFarmId()
        local farm = g_farmManager:getFarmById(farmId)
        if farm then
            farm:changeBalance(amount, "propertyIncome")
            local currencySymbol = g_i18n:getCurrencySymbol()
            local formattedAmount = g_i18n:formatMoney(amount, 0, true)
            local message = string.format(g_i18n:getText("MONEY_ADDED_MESSAGE"), formattedAmount, currencySymbol)
            g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_OK, message)
            print(message)

            -- Envía un mensaje de sincronización a todos los clientes
            AddMoneyEvent.sendEvent(amount)
        else
            print("Error: No se pudo encontrar la granja.")
        end
    end
end

function Surprise:consoleCommandAddMoney(amountStr)
    local amount = tonumber(amountStr)
    if amount ~= nil then
        if g_server ~= nil then
            self:addMoney(amount)
        else
            g_client:getServerConnection():sendEvent(AddMoneyRequestEvent.new(amount))
        end
    else
        print("Error: El monto proporcionado no es un número válido.")
    end
end

addModEventListener(Surprise)
addConsoleCommand("addMoney", "Añadir dinero a la granja", "consoleCommandAddMoney", Surprise)

AddMoneyEvent = {}
AddMoneyEvent_mt = Class(AddMoneyEvent, Event)

function AddMoneyEvent.emptyNew()
    local self = Event.new(AddMoneyEvent_mt)
    return self
end

function AddMoneyEvent.new(amount)
    local self = AddMoneyEvent.emptyNew()
    self.amount = amount
    return self
end

function AddMoneyEvent:readStream(streamId, connection)
    self.amount = streamReadFloat32(streamId)
    self:run(connection)
end

function AddMoneyEvent:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.amount)
end

function AddMoneyEvent:run(connection)
    if not connection:getIsServer() then
        Surprise:addMoney(self.amount)
    end
end

AddMoneyEvent.sendEvent = function(amount)
    if g_server ~= nil then
        g_server:broadcastEvent(AddMoneyEvent.new(amount), true)
    end
end

Event.register(AddMoneyEvent)

AddMoneyRequestEvent = {}
AddMoneyRequestEvent_mt = Class(AddMoneyRequestEvent, Event)

function AddMoneyRequestEvent.emptyNew()
    local self = Event.new(AddMoneyRequestEvent_mt)
    return self
end

function AddMoneyRequestEvent.new(amount)
    local self = AddMoneyRequestEvent.emptyNew()
    self.amount = amount
    return self
end

function AddMoneyRequestEvent:readStream(streamId, connection)
    self.amount = streamReadFloat32(streamId)
    self:run(connection)
end

function AddMoneyRequestEvent:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.amount)
end

function AddMoneyRequestEvent:run(connection)
    if g_server ~= nil then
        Surprise:addMoney(self.amount)
    end
end

AddMoneyRequestEvent.sendEvent = function(amount)
    if g_client ~= nil then
        g_client:getServerConnection():sendEvent(AddMoneyRequestEvent.new(amount))
    end
end

Event.register(AddMoneyRequestEvent)
